/*
 * Decompiled with CFR 0.152.
 */
package ags.disk;

import ags.disk.Drive;
import ags.disk.RWTS;
import java.io.IOException;

public class MiniRWTS
extends RWTS {
    public static int BASE = 241;
    public static int SLOTDRIVE = 241 - BASE;
    public static int BUFFER = 251 - BASE;
    public static int SECTOR_COUNT = 253 - BASE;
    public static int TRACK = 254 - BASE;
    public static int SECTOR = 255 - BASE;
    public int LAST_DRIVE = 0;
    public int LAST_ADDR = 0;
    public int LAST_UNIQUE_ADDR = 0;

    public MiniRWTS() throws IOException {
        super("minirwts", 165, 241, 41, 112, 170, 165);
    }

    public RWTS.CommandBlock parseCommandBlock(byte[] commandBlock) {
        if (commandBlock.length > 16) {
            return null;
        }
        int slot = (commandBlock[SLOTDRIVE] >> 4) - 1;
        int drive = commandBlock[SLOTDRIVE] & 0xF;
        if (slot < 0 || slot > 6) {
            return null;
        }
        if (drive < 0 || drive > 2) {
            return null;
        }
        int ioBuffAddr = 0xFF & commandBlock[BUFFER] | 0xFF00 & commandBlock[BUFFER + 1] << 8;
        if (drive == 0) {
            System.out.println("Drive is 0, buffer is " + Integer.toString(ioBuffAddr, 16));
            drive = this.LAST_DRIVE;
        } else {
            --drive;
        }
        if (ioBuffAddr == this.LAST_UNIQUE_ADDR) {
            this.LAST_ADDR = ioBuffAddr = this.LAST_ADDR + 256;
        } else {
            this.LAST_UNIQUE_ADDR = ioBuffAddr;
            this.LAST_ADDR = ioBuffAddr;
        }
        byte track = commandBlock[TRACK];
        byte sector = commandBlock[SECTOR];
        byte numSectors = commandBlock[SECTOR_COUNT];
        RWTS.CommandBlock theCommand = new RWTS.CommandBlock(this, this);
        theCommand.setSlot(slot);
        theCommand.setDrive(drive);
        theCommand.setTrack(track);
        theCommand.setSector(sector);
        theCommand.setBufferAddress(ioBuffAddr);
        theCommand.setVolume(255);
        theCommand.setSectorCount(numSectors);
        theCommand.setCommand(RWTS.Command.READ);
        System.out.println("MINIRWTS Read: S" + slot + ",D" + drive + ",T" + track + ",S" + sector + ",N" + numSectors);
        return theCommand;
    }

    void advance(RWTS.CommandBlock command) {
        int sector = command.getSector();
        int track = command.getTrack();
        int bufferAddress = command.getBufferAddress();
        if (--sector < 0) {
            sector = 15;
            --track;
        }
        this.LAST_ADDR = bufferAddress;
        command.setSector(sector);
        command.setTrack(track);
        command.setBufferAddress(bufferAddress += 256);
    }

    void finishRWTS(Drive drive, RWTS.CommandBlock command) {
        int bufferAddress = command.getBufferAddress() & 0xFFFF;
        int lo = bufferAddress & 0xFF;
        int hi = bufferAddress >> 8 & 0xFF;
    }

    public boolean isLogicalSector() {
        return true;
    }
}

